#ifndef _GENGINE_H
#define _GENGINE_H

#include "gl.h"
#include "../common.h"

#include <ddraw.h>
#include <dinput.h>


// ĳߴ
#define WIN_WIDTH	640
#define WIN_HEIGHT	352
// tileĳߴ
#define TILE_WIDTH	64
#define TILE_HEIGHT	32
//ĳߴ(ͼ)
#define SCENE_WIDTH		10
#define SCENE_HEIGHT	22
//
#define DIR_UP			0
#define DIR_UPLEFT		1
#define DIR_LEFT		2
#define DIR_DOWNLEFT	3
#define DIR_DOWN		4
#define DIR_DOWNRIGHT	5
#define DIR_RIGHT		6
#define DIR_UPRIGHT		7
#define DIR_UNKNOWN		8
// directdraw
extern LPDIRECTDRAW			lpdd;
extern LPDIRECTDRAWSURFACE	lpDDSScreen;//DirectDraw
extern DDSURFACEDESC		ddsd;
extern CRITICAL_SECTION		dDrawCritical;

extern Bitmap*				screen;		// ʵĻ,ΪDirectDraw
extern Bitmap*				backScreen;	// ͼʱ"Ļ"

// directinput
#define KEYBUFFERSIZE		32	// ̻ĴС
extern LPDIRECTINPUT		lpDI;
extern LPDIRECTINPUTDEVICE	lpDIKeyboard;
extern LPDIRECTINPUTDEVICE	lpDIMouse;

/////////////////////////////////////////////////////////////////////

extern void (*UpdateScreen)( void );	// DirectDraw

int InitDDraw( void );
void RestoreDDraw( void );
void DestroyDDraw( void );
int InitGraphicEngine( DWORD w, DWORD h, DWORD colordepth );
int ExitGraphicEngine( void );

int InitDInput( HINSTANCE hInst );
void DestroyDInput( void );
void DInputSync( int active );
DWORD DInputReadkey( void );

int LockScreen( void );
int UnlockScreen( void );

/////////////////////////////////////////////////////////////////////
// ά
#define MOUSE_L_DOWN	1
#define MOUSE_R_DOWN	2

extern int volatile mouseX, mouseY;	// used by the external code
extern DWORD volatile mousePos;	// high word for X, low word for Y
extern int volatile mouseB; 		// mouse button state
extern int mouseCursorFroze;

void MouseTimerHandler( void );
int InitMouse( void );
void MouseExit( void );
void MouseSetCursor( DWORD type );
void MouseSetFocusPos( int x, int y );
void MouseSetPos( int x, int y );
void MouseSetRange( int l, int t, int r, int b );
void MouseBeforeUpdatescreen( void );
void MouseOn( void );
void MouseOff( void );

/////////////////////////////////////////////////////////////////////
//  ӰЧ

extern Bitmap8 *brightness; // 640x352ϳɺͼ 
extern int brighterInstalled;

int InitBrighter( void );
inline int GetBrightness( int x, int y )
{// ȡ(x,y)
	if( x < 0 ) x = 0;
	else if( x >= WIN_WIDTH ) x = WIN_WIDTH - 1;
	if( y < 0 ) y = 0;
	else if( y >= WIN_HEIGHT ) y = WIN_HEIGHT - 1;
	return brightness->GetPixel( x/2, y/2 );
};
void CopyGroundBrightnessMMX( int sx, int sy );

int testBrighter( void );

/////////////////////////////////////////////////////////////////////
class Anything{
public:
	Bitmap** pic;		//ͼƬ
	int frames;			//ͼƬĿ
	int width, height;	//ͼƬĳߴ
	int baseX, baseY;	//ͼƬĻ

	Anything();
	~Anything();
};

//ֹȫ仯
class StillObj : public Anything{
public:
	virtual int LoadPicture( char *entryName, int level );
	virtual void Draw( Bitmap* dest, int, int, int ) = 0;
};

class Ground : public StillObj{
public:

	virtual int LoadPicture( int level );
	virtual void Draw( Bitmap* dest, int x, int y, int picno );
};

class WallBase : public StillObj{
public:

	virtual int LoadPicture( int level );
	virtual void Draw( Bitmap* dest, int x, int y, int picno );
};

class Wall : public StillObj{
public:
	static short bright[32];

	virtual int LoadPicture( int level );
	virtual void Draw( Bitmap* dest, int x, int y, int picno );
};

/////////////////////////////////////////////////////////////////////
#define MAZE_SIZE	48
//·
#define MaxWayLen	40

class Path{
	BYTE wayPoint[MaxWayLen];
	int len;
	int head;

public:
	Path();
	void Clear( void ){
		len = head;
	};

	bool IsEmpty( void ){
		return head == len;
	};

	int GetWayPoint( void ){
		return wayPoint[head++];
	};

	int FindPath( int sx, int sy, int dx, int dy );
};

//
class Object;

struct Layer{
	Layer *next;
	Object *obj;
};
//Թͼ
/*struct Maze{
	BYTE plot;				//ͼƬ
	BYTE wall;				//ǽڱ,0ʾûǽ
	BYTE wallAttr;			//ǽлʱ,ֵΪ֡
	unsigned wallTrans : 1;	//ǽ͸
	unsigned wallTorch : 1;	//ǽл
	unsigned occupied : 1;	//ռ
	unsigned blocked : 1;	//赲
	unsigned upToDate : 1;	//
	unsigned pending : 1;	//
	unsigned reserved : 2;	//
	Layer *layer;			//
};*/

struct Maze{
	unsigned sprite : 11;
	unsigned obj : 11;
	unsigned occupied : 1;
	unsigned isWall : 1;
	unsigned plot : 8;
};

extern Maze maze[MAZE_SIZE][MAZE_SIZE];

void MapGenerate( void );

// cache𻭳,ҪʱЧ
struct Cache{
	enum{
		NoRefresh			= 0,
		InRefreshTop		= 1,
		InRefreshTopLeft	= 2,
		InRefreshLeft		= 3,
		InRefreshBottomLeft = 4,
		InRefreshBottom		= 5,
		InRefreshBottomRight= 6,
		InRefreshRight		= 7,
		InRefreshTopRight	= 8
	}status;

	int refreshStep;
	Ground floor;
	WallBase wallBase;
	int sceneX, sceneY;
	int mapX, mapY;		//cacheĶӦmap±
	Bitmap* ground;

	// ˢ
	void RefreshTop( void );
	void RefreshTopLeft( void );
	void RefreshLeft( void );
	void RefreshBottomLeft( void );
	void RefreshBottom( void );
	void RefreshBottomRight( void );
	void RefreshRight( void );
	void RefreshTopRight( void );

	int InitCache( int level, int mapx, int mapy );
	void Redraw( int x, int y, int r, int t, int w, int h );
	void DrawGround( int deltax, int deltay );
};
extern Cache cache;

// sceneǽڼʾ
struct Scene{
	int status;		//
	int refreshStep;

	Wall wall;
	int x, y;	//ĻϽǵ±
	int w, h;	//͸
	int deltaX, deltaY;
	int moveX, moveY;
	int centerX, centerY;

	void Draw( void );
	int InitScene( int level, int cx, int cy );
	void Update( void );
	void UpdateStatus( int dir );
	void SetCenter( int cx, int cy );	//ĵ(ͼ)
	void PixelToPlot( int mx, int my, int *px, int *py );
};
extern Scene scene;

/////////////////////////////////////////////////////////////////////

enum SpriteAction{ saNothing = 0, saStand = 0, saFight, saWalk, saSpell, saBeHit };
enum InterType{ itHit = 0, itCharge };
enum ControlType{ ctNothing = 0, ctMouse, ctKey };


//й
struct ActionInfo{
	SpriteAction action;
	WORD destx, desty;
	//Object* target;
	DWORD dir;
};

//ջ,涯
class ActionStack : public CObject{
protected:
	int top;
	ActionInfo element[8];

public:
	ActionStack();
	
	ActionInfo* Pop( void );
	int Push( ActionInfo& );
	ActionInfo* GetTop( void );
	void Clear( void );
};

//
struct Interdata{
	InterType what;
	DWORD info[2];
	void *data;
};

//û¼
struct ControlEvent{
	ControlType what;
	DWORD info[4];
};
/////////////////////////////////////////////////////////////////////

//־
class Object : public CObject{
public:

	DWORD attrib;
	WORD  id;
	WORD mx, my;			//ڵͼеλ

	int  LoginMaze( void );
	void LogoutMaze( void );
	int  LoginCache( void );
	void LogoutCache( void );

	char* GetDescription( void );
	void Interact( Interdata *in = NULL );
	void UpdateStatus( );
	virtual void Update();
};
//оָ
#define MAX_OBJECTS		2048

class ObjectArray{
	Object *obj[MAX_OBJECTS];
	int tail;
public:
	ObjectArray();
	WORD Login( Object* ptr );
	void Logout( WORD id );
	inline void DrawSprite( WORD id ){
		obj[id]->Update();
	};
};
extern ObjectArray objects;

//
class Hero : public Object{
public:

	DWORD timer;			//ʱ,֡Ϊλ
	int deltax, deltay;		//Եͼĵƫ
	WORD destx, desty;		//Ŀλ(ͼ)
	SpriteAction saAction;	//ǰ          107 
	DWORD dir;				//˶,:2 6 
	Path path;				//·()      345
	ActionStack asStack;	//
	Object *target;			//Ŀ
	WORD clickDelay;		//clickʱ

	Animate *stand[8], *fight[8], *walk[8], *behit[8];	//ͼƬ
	RleBitmap *currentFrame;

public:
	Hero( int x, int y );

	int LoadPicture( void );
	void UpdateStatus( ControlEvent *ce );
	virtual void Update( );

protected:
	void Stand( ControlEvent *ce );
	void Walk( ControlEvent *ce );
	void Fight( ControlEvent *ce );
	void BeHit( ControlEvent *ce );

};
extern Hero *warrior;

int testGraphicEngine( void );

#endif
